package de.brightbyte.rdf.vocab;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.rdf.RdfPlatform;
import de.brightbyte.rdf.RdfNamespace;

/**
 * RDF-Schema vocabulary, as defined by http://www.w3.org/TR/2004/REC-rdf-schema-20040210/
 */
public class RDFS<V, R extends V> implements RdfNamespace<V, R> {
	public static final String namespace = "http://www.w3.org/2000/01/rdf-schema#";
	
	public final String prefix;
	
	public final R Resource;
	public final R Class;
	public final R Literal;
	public final R Datatype;
	
	public final R range;
	public final R domain;
	public final R subClassOf;
	public final R subPropertyOf;
	
	public final R label;
	public final R comment;
	
	public final R Container;
	public final R ContainerMembershipProperty;
	public final R member;
	
	public final R seeAlso;
	public final R isDefinedBy;
	
	public RDFS(RdfPlatform<V, R, ?, ?> platform) throws RdfException {
		this(platform, "rdfs");
	}
	
	public RDFS(RdfPlatform<V, R, ?, ?> platform, String prefix) throws RdfException {
		this.prefix = prefix;

		Resource = platform.newResource(namespace, "Resource");
		Class = platform.newResource(namespace, "Class");
		Literal = platform.newResource(namespace, "Literal");
		Datatype = platform.newResource(namespace, "Datatype");
		
		range = platform.newResource(namespace, "range");
		domain = platform.newResource(namespace, "domain");
		subClassOf = platform.newResource(namespace, "subClassOf");
		subPropertyOf = platform.newResource(namespace, "subPropertyOf");
		
		label = platform.newResource(namespace, "label");
		comment = platform.newResource(namespace, "comment");
		
		Container = platform.newResource(namespace, "Container");
		ContainerMembershipProperty = platform.newResource(namespace, "ContainerMembershipProperty");
		member = platform.newResource(namespace, "member");
		
		seeAlso = platform.newResource(namespace, "seeAlso");
		isDefinedBy = platform.newResource(namespace, "isDefinedBy");
		
	}

	public String getNamespace() {
		return namespace;
	}

	public String getPrefix() {
		return prefix;
	}
	
	@Override
	public String toString() {
		return getNamespace();
	}
}
