package de.brightbyte.rdf.vocab;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.rdf.RdfPlatform;
import de.brightbyte.rdf.RdfNamespace;

/**
 * RDF vocabulary, as defined by http://www.w3.org/TR/2004/REC-rdf-schema-20040210/
 */
public class RDF<V, R extends V> implements RdfNamespace<V, R> {
	public static final String namespace = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
	
	public final String prefix;
	
	public final R XMLLiteral;
	public final R Property;
	public final R type;
	
	public final R Bag;
	public final R Seq;
	public final R Alt;
	
	public final R List;
	public final R first;
	public final R rest;
	public final R nil;
	
	public final R Statement;
	public final R subject;
	public final R predicate;
	public final R object;
	
	public final R value;
	
	public RDF(RdfPlatform<V, R, ?, ?> platform) throws RdfException {
		this(platform, "rdf");
	}
	
	public RDF(RdfPlatform<V, R, ?, ?> platform, String prefix) throws RdfException {
		
		this.prefix = prefix;
	
		XMLLiteral = platform.newResource(namespace, "XMLLiteral");
		Property = platform.newResource(namespace, "Property");
		type = platform.newResource(namespace, "type");
		
		Bag = platform.newResource(namespace, "Bag");
		Seq = platform.newResource(namespace, "Seq");
		Alt = platform.newResource(namespace, "Alt");
		
		List = platform.newResource(namespace, "List");
		first = platform.newResource(namespace, "first");
		rest = platform.newResource(namespace, "rest");
		nil = platform.newResource(namespace, "nil");
		
		Statement = platform.newResource(namespace, "Statement");
		subject = platform.newResource(namespace, "subject");
		predicate = platform.newResource(namespace, "predicate");
		object = platform.newResource(namespace, "object");
		
		value = platform.newResource(namespace, "value");
		
	}

	public String getNamespace() {
		return namespace;
	}

	public String getPrefix() {
		return prefix;
	}
	
	@Override
	public String toString() {
		return getNamespace();
	}
}
