package de.brightbyte.rdf.vocab;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.rdf.RdfPlatform;
import de.brightbyte.rdf.RdfNamespace;

/**
 * OWL vocabulary, as defined by http://www.w3.org/TR/2004/REC-owl-ref-20040210/
 */
public class OWL<V, R extends V> implements RdfNamespace<V, R> {
	public static final String namespace = "http://www.w3.org/2002/07/owl#";
	
	public final String prefix;

    public final R allValuesFrom;
    public final R AnnotationProperty;
    public final R backwardCompatibleWith;
    public final R cardinality;
    public final R Class;
    public final R complementOf;
    public final R DatatypeProperty;
    public final R DeprecatedClass;
    public final R DeprecatedProperty;
    public final R DataRange;
    public final R differentFrom;
    public final R disjointWith;
    public final R distinctMembers;
    public final R equivalentClass;
    public final R equivalentProperty;
    public final R FunctionalProperty;
    public final R hasValue;
    public final R imports;
    public final R incompatibleWith;
    public final R intersectionOf;
    public final R InverseFunctionalProperty;
    public final R inverseOf;
    public final R maxCardinality;
    public final R minCardinality;
    public final R Nothing;
    public final R ObjectProperty;
    public final R oneOf;
    public final R onProperty;
    public final R Ontology;
    public final R OntologyProperty;
    public final R priorVersion;
    public final R Restriction;
    public final R sameAs;
    public final R someValuesFrom;
    public final R SymmetricProperty;
    public final R Thing;
    public final R TransitiveProperty;
    public final R unionOf;
    public final R versionInfo;

    public OWL(RdfPlatform<V, R, ?, ?> platform) throws RdfException {
		this(platform, "owl");
	}
	
	public OWL(RdfPlatform<V, R, ?, ?> platform, String prefix) throws RdfException {
		
		this.prefix = prefix;
		
	    allValuesFrom = platform.newResource(namespace, "allValuesFrom");
	    AnnotationProperty = platform.newResource(namespace, "AnnotationProperty");
	    backwardCompatibleWith = platform.newResource(namespace, "backwardCompatibleWith");
	    cardinality = platform.newResource(namespace, "cardinality");
	    Class = platform.newResource(namespace, "Class");
	    complementOf = platform.newResource(namespace, "complementOf");
	    DatatypeProperty = platform.newResource(namespace, "DatatypeProperty");
	    DeprecatedClass = platform.newResource(namespace, "DeprecatedClass");
	    DeprecatedProperty = platform.newResource(namespace, "DeprecatedProperty");
	    DataRange = platform.newResource(namespace, "DataRange");
	    differentFrom = platform.newResource(namespace, "differentFrom");
	    disjointWith = platform.newResource(namespace, "disjointWith");
	    distinctMembers = platform.newResource(namespace, "distinctMembers");
	    equivalentClass = platform.newResource(namespace, "equivalentClass");
	    equivalentProperty = platform.newResource(namespace, "equivalentProperty");
	    FunctionalProperty = platform.newResource(namespace, "FunctionalProperty");
	    hasValue = platform.newResource(namespace, "hasValue");
	    imports = platform.newResource(namespace, "imports");
	    incompatibleWith = platform.newResource(namespace, "incompatibleWith");
	    intersectionOf = platform.newResource(namespace, "intersectionOf");
	    InverseFunctionalProperty = platform.newResource(namespace, "InverseFunctionalProperty");
	    inverseOf = platform.newResource(namespace, "inverseOf");
	    maxCardinality = platform.newResource(namespace, "maxCardinality");
	    minCardinality = platform.newResource(namespace, "minCardinality");
	    Nothing = platform.newResource(namespace, "Nothing");
	    ObjectProperty = platform.newResource(namespace, "ObjectProperty");
	    oneOf = platform.newResource(namespace, "oneOf");
	    onProperty = platform.newResource(namespace, "onProperty");
	    Ontology = platform.newResource(namespace, "Ontology");
	    OntologyProperty = platform.newResource(namespace, "OntologyProperty");
	    priorVersion = platform.newResource(namespace, "priorVersion");
	    Restriction = platform.newResource(namespace, "Restriction");
	    sameAs = platform.newResource(namespace, "sameAs");
	    someValuesFrom = platform.newResource(namespace, "someValuesFrom");
	    SymmetricProperty = platform.newResource(namespace, "SymmetricProperty");
	    Thing = platform.newResource(namespace, "Thing");
	    TransitiveProperty = platform.newResource(namespace, "TransitiveProperty");
	    unionOf = platform.newResource(namespace, "unionOf");
	    versionInfo = platform.newResource(namespace, "versionInfo");
	}

	public String getNamespace() {
		return namespace;
	}

	public String getPrefix() {
		return prefix;
	}
	
	@Override
	public String toString() {
		return getNamespace();
	}
}
