package de.brightbyte.rdf.vocab;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.rdf.RdfPlatform;
import de.brightbyte.rdf.RdfNamespace;

/**
 * FOAF vocabulary, as defined by http://xmlns.com/foaf/spec/
 */
public class FOAF<V, R extends V> implements RdfNamespace<V, R> {
	public static final String namespace = "http://xmlns.com/foaf/0.1/";
	
	public final String prefix;

    public final R accountName;
    public final R accountServiceHomepage;
    public final R Agent;
    public final R aimChatID;
    public final R based_near;
    public final R birthday;
    public final R currentProject;
    public final R depiction;
    public final R depicts;
    public final R dnaChecksum;
    public final R Document;
    public final R family_name;
    public final R firstName;
    public final R fundedBy;
    public final R geekcode;
    public final R gender;
    public final R givenname;
    public final R Group;
    public final R holdsAccount;
    public final R homepage;
    public final R icqChatID;
    public final R Image;
    public final R img;
    public final R interest;
    public final R isPrimaryTopicOf;
    public final R jabberID;
    public final R knows;
    public final R logo;
    public final R made;
    public final R maker;
    public final R mbox;
    public final R mbox_sha1sum;
    public final R member;
    public final R membershipClass;
    public final R msnChatID;
    public final R myersBriggs;
    public final R name;
    public final R nick;
    public final R OnlineAccount;
    public final R OnlineChatAccount;
    public final R OnlineEcommerceAccount;
    public final R OnlineGamingAccount;
    public final R openid;
    public final R Organization;
    public final R page;
    public final R pastProject;
    public final R Person;
    public final R PersonalProfileDocument;
    public final R phone;
    public final R plan;
    public final R primaryTopic;
    public final R Project;
    public final R publications;
    public final R schoolHomepage;
    public final R sha1;
    public final R surname;
    public final R theme;
    public final R thumbnail;
    public final R tipjar;
    public final R title;
    public final R topic;
    public final R topic_interest;
    public final R weblog;
    public final R workInfoHomepage;
    public final R workplaceHomepage;
    public final R yahooChatID;

	public FOAF(RdfPlatform<V, R, ?, ?> platform) throws RdfException {
		this(platform, "foaf");
	}
	
	public FOAF(RdfPlatform<V, R, ?, ?> platform, String prefix) throws RdfException {
		
		this.prefix = prefix;
		
	    accountName = platform.newResource(namespace, "accountName");
	    accountServiceHomepage = platform.newResource(namespace, "accountServiceHomepage");
	    Agent = platform.newResource(namespace, "Agent");
	    aimChatID = platform.newResource(namespace, "aimChatID");
	    based_near = platform.newResource(namespace, "based_near");
	    birthday = platform.newResource(namespace, "birthday");
	    currentProject = platform.newResource(namespace, "currentProject");
	    depiction = platform.newResource(namespace, "depiction");
	    depicts = platform.newResource(namespace, "depicts");
	    dnaChecksum = platform.newResource(namespace, "dnaChecksum");
	    Document = platform.newResource(namespace, "Document");
	    family_name = platform.newResource(namespace, "family_name");
	    firstName = platform.newResource(namespace, "firstName");
	    fundedBy = platform.newResource(namespace, "fundedBy");
	    geekcode = platform.newResource(namespace, "geekcode");
	    gender = platform.newResource(namespace, "gender");
	    givenname = platform.newResource(namespace, "givenname");
	    Group = platform.newResource(namespace, "Group");
	    holdsAccount = platform.newResource(namespace, "holdsAccount");
	    homepage = platform.newResource(namespace, "homepage");
	    icqChatID = platform.newResource(namespace, "icqChatID");
	    Image = platform.newResource(namespace, "Image");
	    img = platform.newResource(namespace, "img");
	    interest = platform.newResource(namespace, "interest");
	    isPrimaryTopicOf = platform.newResource(namespace, "isPrimaryTopicOf");
	    jabberID = platform.newResource(namespace, "jabberID");
	    knows = platform.newResource(namespace, "knows");
	    logo = platform.newResource(namespace, "logo");
	    made = platform.newResource(namespace, "made");
	    maker = platform.newResource(namespace, "maker");
	    mbox = platform.newResource(namespace, "mbox");
	    mbox_sha1sum = platform.newResource(namespace, "mbox_sha1sum");
	    member = platform.newResource(namespace, "member");
	    membershipClass = platform.newResource(namespace, "membershipClass");
	    msnChatID = platform.newResource(namespace, "msnChatID");
	    myersBriggs = platform.newResource(namespace, "myersBriggs");
	    name = platform.newResource(namespace, "name");
	    nick = platform.newResource(namespace, "nick");
	    OnlineAccount = platform.newResource(namespace, "OnlineAccount");
	    OnlineChatAccount = platform.newResource(namespace, "OnlineChatAccount");
	    OnlineEcommerceAccount = platform.newResource(namespace, "OnlineEcommerceAccount");
	    OnlineGamingAccount = platform.newResource(namespace, "OnlineGamingAccount");
	    openid = platform.newResource(namespace, "openid");
	    Organization = platform.newResource(namespace, "Organization");
	    page = platform.newResource(namespace, "page");
	    pastProject = platform.newResource(namespace, "pastProject");
	    Person = platform.newResource(namespace, "Person");
	    PersonalProfileDocument = platform.newResource(namespace, "PersonalProfileDocument");
	    phone = platform.newResource(namespace, "phone");
	    plan = platform.newResource(namespace, "plan");
	    primaryTopic = platform.newResource(namespace, "primaryTopic");
	    Project = platform.newResource(namespace, "Project");
	    publications = platform.newResource(namespace, "publications");
	    schoolHomepage = platform.newResource(namespace, "schoolHomepage");
	    sha1 = platform.newResource(namespace, "sha1");
	    surname = platform.newResource(namespace, "surname");
	    theme = platform.newResource(namespace, "theme");
	    thumbnail = platform.newResource(namespace, "thumbnail");
	    tipjar = platform.newResource(namespace, "tipjar");
	    title = platform.newResource(namespace, "title");
	    topic = platform.newResource(namespace, "topic");
	    topic_interest = platform.newResource(namespace, "topic_interest");
	    weblog = platform.newResource(namespace, "weblog");
	    workInfoHomepage = platform.newResource(namespace, "workInfoHomepage");
	    workplaceHomepage = platform.newResource(namespace, "workplaceHomepage");
	    yahooChatID = platform.newResource(namespace, "yahooChatID");
	}

	public String getNamespace() {
		return namespace;
	}

	public String getPrefix() {
		return prefix;
	}
	
	@Override
	public String toString() {
		return getNamespace();
	}
}
