package de.brightbyte.rdf.vocab;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.rdf.RdfPlatform;
import de.brightbyte.rdf.RdfNamespace;

/**
 * Dublin Core vocabulary, as defined by http://dublincore.org/documents/dcmi-terms/
 */
public class DC<V, R extends V> implements RdfNamespace<V, R> {
	public static final String namespace = "http://purl.org/dc/terms/";
	
	public final String prefix;

    public final R _abstract;
    public final R accessRights;
    public final R accrualMethod;
    public final R accrualPeriodicity;
    public final R accrualPolicy;
    public final R alternative;
    public final R audience;
    public final R available;
    public final R bibliographicCitation;
    public final R conformsTo;
    public final R contributor;
    public final R coverage;
    public final R created;
    public final R creator;
    public final R date;
    public final R dateAccepted;
    public final R dateCopyrighted;
    public final R dateSubmitted;
    public final R description;
    public final R educationLevel;
    public final R extent;
    public final R format;
    public final R hasFormat;
    public final R hasPart;
    public final R hasVersion;
    public final R identifier;
    public final R instructionalMethod;
    public final R isFormatOf;
    public final R isPartOf;
    public final R isReferencedBy;
    public final R isReplacedBy;
    public final R isRequiredBy;
    public final R issued;
    public final R isVersionOf;
    public final R language;
    public final R license;
    public final R mediator;
    public final R medium;
    public final R modified;
    public final R provenance;
    public final R publisher;
    public final R references;
    public final R relation;
    public final R replaces;
    public final R requires;
    public final R rights;
    public final R rightsHolder;
    public final R source;
    public final R spatial;
    public final R subject;
    public final R tableOfContents;
    public final R temporal;
    public final R title;
    public final R type;
    public final R valid;

    public DC(RdfPlatform<V, R, ?, ?> platform) throws RdfException {
		this(platform, "dc");
	}
	
	public DC(RdfPlatform<V, R, ?, ?> platform, String prefix) throws RdfException {
		
		this.prefix = prefix;
		
	    _abstract = platform.newResource(namespace, "abstract");
	    accessRights = platform.newResource(namespace, "accessRights");
	    accrualMethod = platform.newResource(namespace, "accrualMethod");
	    accrualPeriodicity = platform.newResource(namespace, "accrualPeriodicity");
	    accrualPolicy = platform.newResource(namespace, "accrualPolicy");
	    alternative = platform.newResource(namespace, "alternative");
	    audience = platform.newResource(namespace, "audience");
	    available = platform.newResource(namespace, "available");
	    bibliographicCitation = platform.newResource(namespace, "bibliographicCitation");
	    conformsTo = platform.newResource(namespace, "conformsTo");
	    contributor = platform.newResource(namespace, "contributor");
	    coverage = platform.newResource(namespace, "coverage");
	    created = platform.newResource(namespace, "created");
	    creator = platform.newResource(namespace, "creator");
	    date = platform.newResource(namespace, "date");
	    dateAccepted = platform.newResource(namespace, "dateAccepted");
	    dateCopyrighted = platform.newResource(namespace, "dateCopyrighted");
	    dateSubmitted = platform.newResource(namespace, "dateSubmitted");
	    description = platform.newResource(namespace, "description");
	    educationLevel = platform.newResource(namespace, "educationLevel");
	    extent = platform.newResource(namespace, "extent");
	    format = platform.newResource(namespace, "format");
	    hasFormat = platform.newResource(namespace, "hasFormat");
	    hasPart = platform.newResource(namespace, "hasPart");
	    hasVersion = platform.newResource(namespace, "hasVersion");
	    identifier = platform.newResource(namespace, "identifier");
	    instructionalMethod = platform.newResource(namespace, "instructionalMethod");
	    isFormatOf = platform.newResource(namespace, "isFormatOf");
	    isPartOf = platform.newResource(namespace, "isPartOf");
	    isReferencedBy = platform.newResource(namespace, "isReferencedBy");
	    isReplacedBy = platform.newResource(namespace, "isReplacedBy");
	    isRequiredBy = platform.newResource(namespace, "isRequiredBy");
	    issued = platform.newResource(namespace, "issued");
	    isVersionOf = platform.newResource(namespace, "isVersionOf");
	    language = platform.newResource(namespace, "language");
	    license = platform.newResource(namespace, "license");
	    mediator = platform.newResource(namespace, "mediator");
	    medium = platform.newResource(namespace, "medium");
	    modified = platform.newResource(namespace, "modified");
	    provenance = platform.newResource(namespace, "provenance");
	    publisher = platform.newResource(namespace, "publisher");
	    references = platform.newResource(namespace, "references");
	    relation = platform.newResource(namespace, "relation");
	    replaces = platform.newResource(namespace, "replaces");
	    requires = platform.newResource(namespace, "requires");
	    rights = platform.newResource(namespace, "rights");
	    rightsHolder = platform.newResource(namespace, "rightsHolder");
	    source = platform.newResource(namespace, "source");
	    spatial = platform.newResource(namespace, "spatial");
	    subject = platform.newResource(namespace, "subject");
	    tableOfContents = platform.newResource(namespace, "tableOfContents");
	    temporal = platform.newResource(namespace, "temporal");
	    title = platform.newResource(namespace, "title");
	    type = platform.newResource(namespace, "type");
	    valid = platform.newResource(namespace, "valid");
	}

	public String getNamespace() {
		return namespace;
	}

	public String getPrefix() {
		return prefix;
	}
	
	@Override
	public String toString() {
		return getNamespace();
	}
}
