package de.brightbyte.rdf.sesame;

import org.openrdf.model.Graph;
import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.sesame.sail.StatementIterator;

public class AboutURI implements URI, About {
	protected URI uri;
	protected Graph graph;
	
	public AboutURI(URI uri) {
		this(uri, new GraphImpl());
	}

	public AboutURI(URI uri, Graph graph) {
		super();
		this.uri = uri;
		this.graph = graph;
	}

	public void addProperty(URI predicate, Value object) throws GraphException {
		graph.add(this, predicate, object);
	}
	
	public int compareTo(Object o) {
		return uri.compareTo(o);
	}
	
	public String getLocalName() {
		return uri.getLocalName();
	}
	
	public String getNamespace() {
		return uri.getNamespace();
	}
	
	public StatementIterator getObjectStatements() throws GraphException {
		return graph.getStatements(null, null, uri);
	}
	
	public StatementIterator getPredicateStatements() throws GraphException {
		return graph.getStatements(null, uri, null);
	}
	
	public StatementIterator getSubjectStatements() throws GraphException {
		return graph.getStatements(uri, null, null);
	}
	
	public String getURI() {
		return uri.getURI();
	}

	@Override
	public String toString() {
		return uri.toString();
	}

	@Override
	public int hashCode() {
		return uri.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof URI))
			return false;
		final URI other = (URI) obj;
		
		if (!uri.getNamespace().equals(other.getNamespace())) return false;
		if (!uri.getLocalName().equals(other.getLocalName())) return false;
		return true;
	}

	
}
