package de.brightbyte.rdf.sesame;

import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.sesame.sail.StatementIterator;

public class AboutBNode implements BNode, About {
	protected BNode node;
	protected Graph graph;
	
	public AboutBNode(BNode node) {
		this(node, new GraphImpl());
	}

	public AboutBNode(BNode node, Graph graph) {
		super();
		this.node = node;
		this.graph = graph;
	}

	public void addProperty(URI predicate, Value object) throws GraphException {
		graph.add(this, predicate, object);
	}
	
	public int compareTo(Object o) {
		return node.compareTo(o);
	}
	
	public StatementIterator getObjectStatements() throws GraphException {
		return graph.getStatements(null, null, node);
	}
	
	public StatementIterator getSubjectStatements() throws GraphException {
		return graph.getStatements(node, null, null);
	}
	
	@Override
	public String toString() {
		return node.toString();
	}

	@Override
	public int hashCode() {
		return node.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof BNode))
			return false;
		final BNode other = (BNode) obj;
		
		if (!node.getID().equals(other.getID())) return false;
		return true;
	}

	public String getID() {
		return node.getID();
	}

	
}
