package de.brightbyte.rdf.aardfark;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.MessageFormat;

public class RdfUtil {
	public static final URI rdfBase;

	static {
		try {
			rdfBase = new URI("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
		}
		catch (URISyntaxException ex) {
			throw new Error(ex);
		}
	}

	public static URI makeURI(URI base, String name) {
		try {
			return base == null ? new URI(name) : new URI(base+URLEncoder.encode(name, "UTF-8"));
		} catch (URISyntaxException e) {
			throw new IllegalArgumentException("bad uri: "+base+name, e);
		} catch (UnsupportedEncodingException e) {
			throw new Error("UTF-8 not supported", e);
		}
	}

	public static URI makeURI(String pattern, String... args) {
		String u = MessageFormat.format(pattern, (Object[])args);
		
		try {
			return new URI( u );
		} catch (URISyntaxException e) {
			throw new IllegalArgumentException("bad uri: "+u, e);
		}
	}

}
