package de.brightbyte.rdf.aardfark;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import de.brightbyte.io.Output;
import de.brightbyte.io.WriterOutput;
import de.brightbyte.rdf.RdfException;
import de.brightbyte.util.PersistenceException;

public abstract class RdfStreamSink extends AbstractRdfSink   {
	
	protected Output output;
	protected boolean closeStream = false;
	
	public RdfStreamSink(RdfContext context, File f, String enc) throws UnsupportedEncodingException, FileNotFoundException {
		this(context, new BufferedOutputStream(new FileOutputStream(f)), enc);
		closeStream = true;
	}
	
	public RdfStreamSink(RdfContext context, OutputStream out, String enc) throws UnsupportedEncodingException {
		this(context, new WriterOutput(out, enc));
	}
	
	public RdfStreamSink(RdfContext context, Writer out) {
		this(context, new WriterOutput(out));
	}
	
	public RdfStreamSink(RdfContext context, Output output) {
		super(context);
		this.output = output;
	}

	public void finish() throws RdfException, PersistenceException {
		try {
			if (closeStream) output.close();
			else output.flush();
		} catch (IOException e) {
			throw new PersistenceException(e);
		}
	}

	protected void write(String s) throws RdfException, PersistenceException {
		try {
			output.write(s);
		} catch (IOException e) {
			throw new PersistenceException(e);
		}
	}
	
	protected void writeln(String s) throws RdfException, PersistenceException {
		try {
			output.writeln(s);
		} catch (IOException e) {
			throw new PersistenceException(e);
		}
	}

	public void close() throws RdfException, PersistenceException {
		try {
			output.close();
		} catch (IOException e) {
			throw new PersistenceException(e);
		}
	}

	public void flush() throws RdfException, PersistenceException {
		try {
			output.flush();
		} catch (IOException e) {
			throw new PersistenceException(e);
		}
	}

}
