package de.brightbyte.rdf.aardfark;

import java.util.List;
import java.util.Map;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.util.PersistenceException;

/**
 * An RdfSink is something RDF statements can be send to. In practice, it may be
 * implemented as an RDF serializer, or as a wrapper for an RDF store. 
 */
public interface RdfSink {
	public void prepare() throws RdfException, PersistenceException;
	public void finish() throws RdfException, PersistenceException;
	
//	public void putStatement(String qsubject, String qpredicate, String qobject) throws RdfSinkException, RdfVocabException;
//	public void putStatement(URI subject, URI predicate, URI object) throws RdfSinkException;
	public void putStatement(RdfResource subject, RdfResource predicate, RdfValue object) throws RdfException, PersistenceException;
	public void putAbout(RdfAbout about) throws RdfException, PersistenceException;
	public void putAbout(RdfResource subject, Map<RdfResource, RdfValue> properties) throws RdfException, PersistenceException;
	public void putAbout(RdfResource subject, List<RdfPropertyInstance> properties) throws RdfException, PersistenceException;
	public void flush() throws RdfException, PersistenceException;
	public void close() throws RdfException, PersistenceException;
}
