package de.brightbyte.rdf.aardfark;

import de.brightbyte.rdf.RdfException;


public class RdfReference extends RdfResource {
	protected String namespace; 
	protected String name; 

	public RdfReference(RdfContext context, String namespace, String name) throws RdfException {
		this.namespace = namespace;
		this.name= name;
	}
	
	public String getNamespace() {
		return namespace;
	}
	
	public String getLocalName() {
		return name;
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((name == null) ? 0 : name.hashCode());
		result = PRIME * result + ((namespace == null) ? 0 : namespace.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RdfReference other = (RdfReference) obj;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (namespace == null) {
			if (other.namespace != null)
				return false;
		} else if (!namespace.equals(other.namespace))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return namespace+name;
	}

}
