package de.brightbyte.rdf.aardfark;

public class RdfPropertyInstance {
	
	protected RdfResource predicate;
	protected RdfValue object;
	
	public RdfPropertyInstance(RdfResource predicate, RdfValue object) {
		if (predicate==null) throw new NullPointerException();
		if (object==null) throw new NullPointerException();
		
		this.predicate = predicate;
		this.object = object;
	}
	
	@Override
	public String toString() {
		return predicate + " " + object;
	}

	public RdfValue getObject() {
		return object;
	}

	public RdfResource getPredicate() {
		return predicate;
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((object == null) ? 0 : object.hashCode());
		result = PRIME * result + ((predicate == null) ? 0 : predicate.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RdfPropertyInstance other = (RdfPropertyInstance) obj;
		if (object == null) {
			if (other.object != null)
				return false;
		} else if (!object.equals(other.object))
			return false;
		if (predicate == null) {
			if (other.predicate != null)
				return false;
		} else if (!predicate.equals(other.predicate))
			return false;
		return true;
	}
	
	

}
