package de.brightbyte.rdf.aardfark;

import de.brightbyte.rdf.RdfException;



public class RdfLiteral extends RdfValue {
	protected String language;
	protected String value;
	protected RdfResource type;

	public RdfLiteral(String value) {
		this.value = value;
	}
	
	public RdfLiteral(String value, RdfContext context, String vocab, String typeName) throws RdfException {
		this(value, new RdfReference(context, vocab, typeName));
	}
	
	public RdfLiteral(String value, String language) {
		this(value); //XXX: use http://www.w3.org/TR/xmlschema-2/#string ?
		this.language = language;
	}
	
	public RdfLiteral(String value, RdfResource type) {
		this(value); 
		this.type = type;
	}
	
	public String getLanguage() {
		return language;
	}
	
	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((language == null) ? 0 : language.hashCode());
		result = PRIME * result + ((type == null) ? 0 : type.hashCode());
		result = PRIME * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RdfLiteral other = (RdfLiteral) obj;
		if (language == null) {
			if (other.language != null)
				return false;
		} else if (!language.equals(other.language))
			return false;
		if (type == null) {
			if (other.type != null)
				return false;
		} else if (!type.equals(other.type))
			return false;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}

	@Override
	public String toString() {
		String s = "\""+value.replace("\\", "\\\\").replace("\"", "\\\"")+"\"";
		if (type != null) s += "^^" + type.toString();
		if (language != null) s += "@" + language;
		return s;
	}

	public String getValue() {
		return value;
	}
	
	public RdfResource getType() {
		return type;
	}
}
