package de.brightbyte.rdf.aardfark;

import java.util.ArrayList;
import java.util.List;

import de.brightbyte.rdf.RdfException;

public class RdfAbout extends RdfValue {
	protected List<RdfPropertyInstance> properties = new ArrayList<RdfPropertyInstance>();
	protected RdfResource resource;
	
	public RdfAbout(RdfContext context, String namespace, String name) throws RdfException {
		this(new RdfReference(context, namespace, name));
	}

	public RdfAbout(RdfResource resource) throws RdfException {
		this.resource = resource;
	}

	public RdfAbout() throws RdfException {
		this(new RdfNode());
	}

	public List<RdfPropertyInstance>  getProperies() {
		return properties;
	}
	
	public void setProperty(RdfResource predicate, RdfValue object) {
		properties.add(new RdfPropertyInstance(predicate, object));
	}

	public RdfResource getResource() {
		return resource;
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((resource == null) ? 0 : resource.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RdfAbout other = (RdfAbout) obj;
		if (resource == null) {
			if (other.resource != null)
				return false;
		} else if (!resource.equals(other.resource))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return resource.toString();
	}
	
}
