package de.brightbyte.rdf.aardfark;

import java.util.List;
import java.util.Map;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.util.PersistenceException;


public abstract class AbstractRdfSink implements RdfSink {
	protected RdfContext context;
	
	public AbstractRdfSink(RdfContext context) {
		super();
		this.context = context;
	}

	/*
	public void putStatement(URI subject, URI predicate, URI object) throws RdfSinkException {
		putStatement(makeReference(subject), makeReference(predicate), makeReference(object));
	}
	*/

	public void putAbout(RdfAbout about) throws RdfException, PersistenceException {
		putAbout(about.getResource(), about.getProperies());
	}

	public void putAbout(RdfResource subject, Map<RdfResource, RdfValue> properties) throws RdfException, PersistenceException {
		for (Map.Entry<RdfResource, RdfValue> prop : properties.entrySet()) {
			putStatement(subject, prop.getKey(), prop.getValue());
		}
	}

	public void putAbout(RdfResource subject, List<RdfPropertyInstance> properties) throws RdfException, PersistenceException {
		for (RdfPropertyInstance prop : properties) {
			putStatement(subject, prop.getPredicate(), prop.getObject());
		}
	}

}
