package de.brightbyte.rdf;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;

import de.brightbyte.util.PersistenceException;

/**
 * 
 * @author daniel
 *
 * @param <V> value type (resource/reference/blanknode/literal)
 * @param <R> Resource Reference type (URI/QName or blank node)
 * @param <A> Resource with a set of property collection ("about")
 * @param <W> Writer type
 */
public interface RdfPlatform<V, R extends V, A, W> {

	public GenericNamespace<V, R> addNamespace(String namespace, String prefix) throws RdfException;
	public void addNamespace(RdfNamespace<V, R> ns) throws RdfException;
	public RdfNamespace<V, R> getNamespace(String namespace) throws RdfException;
	public Collection<RdfNamespace<V, R>> getNamespaces();
	
	public String getBaseURI();
	public void setBaseURI(String uri) throws RdfException;

	public <N extends RdfNamespace<V, R>> N aquireNamespace(Class<N> namespace) throws RdfException;
	
	public A newAbout(R resource) throws RdfException;
	public R newResource(String namespace, String name) throws RdfException;
	public R newNode() throws RdfException;
	
	public V newLiteral(String value, String language) throws RdfException;
	public V newLiteral(String value, R datatype) throws RdfException;
	
	public W newWriter(String location, String format) throws RdfException, PersistenceException;
	public W newWriter(OutputStream out, String format) throws RdfException, PersistenceException;
	public W newWriter(Writer out, String format) throws RdfException, PersistenceException;
	
	public void flushWriter(W writer) throws RdfException, PersistenceException;
	public void closeWriter(W writer) throws RdfException, PersistenceException;
	
	public String[] getSupportedFormats() throws RdfException;
	public String[] getSupportedFormats(String location) throws RdfException;
	
	public void setProperty(A subject, R predicate, V object) throws RdfException;
	public void setLiteralProperty(A about, R property, String value, String lang) throws RdfException;
	public void setLiteralProperty(A about, R property, String value, R datatype) throws RdfException;
	public void setReferenceProperty(A about, R property, String namespace, String name) throws RdfException;
	
	public void writeStatement(W writer, R subject, R predicate, V object) throws RdfException, PersistenceException;
	public void writeResource(W writer, A about) throws RdfException, PersistenceException;
	
	public void writeHead(W writer) throws RdfException, PersistenceException;
	public void writeFoot(W writer) throws RdfException, PersistenceException;
}
