package de.brightbyte.rdf;

import java.util.ArrayList;
import java.util.Collection;

public class GenericRdfalizer<V, R extends V, A, T> implements Rdfalizer<V, R, A, T> {

	protected RdfPlatform<V, R, A, ?> platform;
	protected Collection<RdfProperties<V, R, A, T>> properties = new ArrayList<RdfProperties<V, R, A, T>>();
	
	public GenericRdfalizer(RdfPlatform<V, R, A, ?> platform) {
		super();
		this.platform = platform;
	}

	public A getRdf(String namespace, String name, T obj) throws RdfException {
		R rc = platform.newResource(namespace, name);
		A about = platform.newAbout(rc);
		
		for (RdfProperties<V, R, A, T> p: properties) {
			p.addProperties(obj, about);
		}
		
		return about;
	}

	public void addProperties(RdfProperties<V, R, A, T> props) {
		properties.add(props);
	}

}
