package de.brightbyte.rdf;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.rdf.RdfNamespace;
import de.brightbyte.rdf.RdfPlatform;

/**
 * Dublin Core vocabulary, as defined by http://dublincore.org/documents/dcmi-terms/
 */
public class GenericNamespace<V, R extends V> implements RdfNamespace<V, R> {
	public final String namespace;
	public final String prefix;
	
	protected RdfPlatform<V, R, ?, ?> platform;
 
	public GenericNamespace(RdfPlatform<V, R, ?, ?> platform, String namespace, String prefix) throws RdfException {
		this.platform = platform;
		this.namespace = namespace;
		this.prefix = prefix;
	}
	
	public R getResource(String name) throws RdfException {
		return platform.newResource(namespace, name);
	}

	public String getNamespace() {
		return namespace;
	}

	public String getPrefix() {
		return prefix;
	}
	
	@Override
	public String toString() {
		return getNamespace();
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((namespace == null) ? 0 : namespace.hashCode());
		result = PRIME * result + ((prefix == null) ? 0 : prefix.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final GenericNamespace other = (GenericNamespace) obj;
		if (namespace == null) {
			if (other.namespace != null)
				return false;
		} else if (!namespace.equals(other.namespace))
			return false;
		if (prefix == null) {
			if (other.prefix != null)
				return false;
		} else if (!prefix.equals(other.prefix))
			return false;
		return true;
	}
	
	
}
