package de.brightbyte.rdf;

public abstract class AbstractProperties<V, R extends V, A, T> implements RdfProperties<V, R, A, T> {

	protected RdfPlatform<V, R, A, ?> platform;

	public AbstractProperties(RdfPlatform<V, R, A, ?> platform) {
		this.platform = platform;
	}

	protected void setLiteralProperty(A about, R property, String value, String lang) throws RdfException {
		setProperty(about, property, platform.newLiteral(value, lang));
	}
	
	protected void setLiteralProperty(A about, R property, String value, R datatype) throws RdfException {
		setProperty(about, property, platform.newLiteral(value, datatype));
	}
	
	protected void setReferenceProperty(A about, R property, String namespace, String name) throws RdfException {
		setProperty(about, property, platform.newResource(namespace, name));
	}
	
	protected void setProperty(A about, R property, V value) throws RdfException {
		platform.setProperty(about, property, value);
	}
}
