package de.brightbyte.db.file;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import de.brightbyte.db.DatabaseTable;
import de.brightbyte.db.Inserter;

public class TestData {
	public class TestResultSet implements ResultSet {
		protected Map<String, Object> row;
		protected Iterator<Map<String, Object>> it;

		public TestResultSet() {
			it = data.iterator();
		}
		
		public boolean absolute(int row) throws SQLException {
			throw new UnsupportedOperationException(); 
		}

		public void afterLast() throws SQLException {
			throw new UnsupportedOperationException(); 
		}

		public void beforeFirst() throws SQLException {
			throw new UnsupportedOperationException(); 
		}

		public void cancelRowUpdates() throws SQLException {
			throw new UnsupportedOperationException(); 
		}

		public void clearWarnings() throws SQLException {
			throw new UnsupportedOperationException(); 
		}

		public void close() throws SQLException {
			//noop
		}

		public void deleteRow() throws SQLException {
			throw new UnsupportedOperationException(); 
		}

		public int findColumn(String columnName) throws SQLException {
			return Arrays.binarySearch(columns, columnName);
		}

		public boolean first() throws SQLException {
			throw new UnsupportedOperationException(); 
		}

		public Array getArray(int columnIndex) throws SQLException {
			return getArray(columns[columnIndex]);
		}

		public Array getArray(String colName) throws SQLException {
			return (Array)getObject(colName);
		}

		public InputStream getAsciiStream(int columnIndex) throws SQLException {
			return getAsciiStream(columns[columnIndex]);
		}

		public InputStream getAsciiStream(String columnName)
				throws SQLException {
			return (InputStream)getObject(columnName);
		}

		public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
			return getBigDecimal(columns[columnIndex]);
		}

		public BigDecimal getBigDecimal(String columnName) throws SQLException {
			return (BigDecimal)getObject(columnName);
		}

		public BigDecimal getBigDecimal(int columnIndex, int scale)
				throws SQLException {
			return getBigDecimal(columns[columnIndex], scale);
		}

		public BigDecimal getBigDecimal(String columnName, int scale)
				throws SQLException {
			return getBigDecimal(columnName);
		}

		public InputStream getBinaryStream(int columnIndex) throws SQLException {
			return getBinaryStream(columns[columnIndex]);
		}

		public InputStream getBinaryStream(String columnName)
				throws SQLException {
			return (InputStream)getObject(columnName);
		}

		public Blob getBlob(int i) throws SQLException {
			return getBlob(columns[i]);
		}

		public Blob getBlob(String colName) throws SQLException {
			return (Blob)getObject(colName);
		}

		public boolean getBoolean(int columnIndex) throws SQLException {
			return getBoolean(columns[columnIndex]);
		}

		public boolean getBoolean(String columnName) throws SQLException {
			return (Boolean)getObject(columnName);
		}

		public byte getByte(int columnIndex) throws SQLException {
			return getByte(columns[columnIndex]);
		}

		public byte getByte(String columnName) throws SQLException {
			return (Byte)getObject(columnName);
		}

		public byte[] getBytes(int columnIndex) throws SQLException {
			return getBytes(columns[columnIndex]);
		}

		public byte[] getBytes(String columnName) throws SQLException {
			return (byte[])getObject(columnName);
		}

		public Reader getCharacterStream(int columnIndex) throws SQLException {
			return getCharacterStream(columns[columnIndex]);
		}

		public Reader getCharacterStream(String columnName) throws SQLException {
			return (Reader)getObject(columnName);
		}

		public Clob getClob(int i) throws SQLException {
			return getClob(columns[i]);
		}

		public Clob getClob(String colName) throws SQLException {
			return (Clob)getObject(colName);
		}

		public int getConcurrency() throws SQLException {
			return ResultSet.CONCUR_READ_ONLY;
		}

		public String getCursorName() throws SQLException {
			return "TEST";
		}

		public Date getDate(int columnIndex) throws SQLException {
			return getDate(columns[columnIndex]);
		}

		public Date getDate(String columnName) throws SQLException {
			return (Date)getObject(columnName);
		}

		public Date getDate(int columnIndex, Calendar cal) throws SQLException {
			return getDate(columns[columnIndex]);
		}

		public Date getDate(String columnName, Calendar cal)
				throws SQLException {
			return getDate(columnName);
		}

		public double getDouble(int columnIndex) throws SQLException {
			return getDouble(columns[columnIndex]);
		}

		public double getDouble(String columnName) throws SQLException {
			return ((Double)getObject(columnName)).doubleValue();
		}

		public int getFetchDirection() throws SQLException {
			return ResultSet.FETCH_FORWARD;
		}

		public int getFetchSize() throws SQLException {
			return 1;
		}

		public float getFloat(int columnIndex) throws SQLException {
			return getFloat(columns[columnIndex]);
		}

		public float getFloat(String columnName) throws SQLException {
			return ((Number)getObject(columnName)).floatValue();
		}

		public int getInt(int columnIndex) throws SQLException {
			return getInt(columns[columnIndex]);
		}

		public int getInt(String columnName) throws SQLException {
			return ((Integer)getObject(columnName)).intValue();
		}

		public long getLong(int columnIndex) throws SQLException {
			return getLong(columns[columnIndex]);
		}

		public long getLong(String columnName) throws SQLException {
			return ((Number)getObject(columnName)).longValue();
		}

		public ResultSetMetaData getMetaData() throws SQLException {
			return null;
		}

		public Object getObject(int columnIndex) throws SQLException {
			return getObject(columns[columnIndex]);
		}

		public Object getObject(String columnName) throws SQLException {
			return row.get(columnName);
		}

		public Object getObject(int i, Map<String, Class<?>> map)
				throws SQLException {
			return getObject(columns[i]);
		}

		public Object getObject(String colName, Map<String, Class<?>> map)
				throws SQLException {
			return getObject(colName);
		}

		public Ref getRef(int i) throws SQLException {
			return getRef(columns[i]);
		}

		public Ref getRef(String colName) throws SQLException {
			return (Ref)getObject(colName);
		}

		public int getRow() throws SQLException {
			return -1;
		}

		public short getShort(int columnIndex) throws SQLException {
			return getShort(columns[columnIndex]);
		}

		public short getShort(String columnName) throws SQLException {
			return ((Number)getObject(columnName)).shortValue();
		}

		public Statement getStatement() throws SQLException {
			return null;
		}

		public String getString(int columnIndex) throws SQLException {
			return getString(columns[columnIndex]);
		}

		public String getString(String columnName) throws SQLException {
			return (String)getObject(columnName);
		}

		public Time getTime(int columnIndex) throws SQLException {
			return getTime(columns[columnIndex]);
		}

		public Time getTime(String columnName) throws SQLException {
			return (Time)getObject(columnName);
		}

		public Time getTime(int columnIndex, Calendar cal) throws SQLException {
			return getTime(columns[columnIndex]);
		}

		public Time getTime(String columnName, Calendar cal)
				throws SQLException {
			return getTime(columnName);
		}

		public Timestamp getTimestamp(int columnIndex) throws SQLException {
			return getTimestamp(columns[columnIndex]);
		}

		public Timestamp getTimestamp(String columnName) throws SQLException {
			return (Timestamp)getObject(columnName);
		}

		public Timestamp getTimestamp(int columnIndex, Calendar cal)
				throws SQLException {
			return getTimestamp(columns[columnIndex]);
		}

		public Timestamp getTimestamp(String columnName, Calendar cal)
				throws SQLException {
			return getTimestamp(columnName);
		}

		public int getType() throws SQLException {
			return ResultSet.TYPE_FORWARD_ONLY;
		}

		public URL getURL(int columnIndex) throws SQLException {
			return getURL(columns[columnIndex]);
		}

		public URL getURL(String columnName) throws SQLException {
			return (URL)getObject(columnName);
		}

		public InputStream getUnicodeStream(int columnIndex)
				throws SQLException {
			return getUnicodeStream(columns[columnIndex]);
		}

		public InputStream getUnicodeStream(String columnName)
				throws SQLException {
			return (InputStream)getObject(columnName);
		}

		public SQLWarning getWarnings() throws SQLException {
			return null;
		}

		public void insertRow() throws SQLException {
			throw new UnsupportedOperationException();
		}

		public boolean isAfterLast() throws SQLException {
			return false;
		}

		public boolean isBeforeFirst() throws SQLException {
			return false;
		}

		public boolean isFirst() throws SQLException {
			return false;
		}

		public boolean isLast() throws SQLException {
			return true;
		}

		public boolean last() throws SQLException {
			return true;
		}

		public void moveToCurrentRow() throws SQLException {
			//noop
		}

		public void moveToInsertRow() throws SQLException {
			throw new UnsupportedOperationException();
		}

		public boolean next() throws SQLException {
			if (!it.hasNext()) return false;
			row = it.next();
			return true;
		}

		public boolean previous() throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void refreshRow() throws SQLException {
			throw new UnsupportedOperationException();
		}

		public boolean relative(int rows) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public boolean rowDeleted() throws SQLException {
			return false;
		}

		public boolean rowInserted() throws SQLException {
			return false;
		}

		public boolean rowUpdated() throws SQLException {
			return false;
		}

		public void setFetchDirection(int direction) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void setFetchSize(int rows) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateArray(int columnIndex, Array x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateArray(String columnName, Array x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateAsciiStream(int columnIndex, InputStream x, int length)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateAsciiStream(String columnName, InputStream x,
				int length) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateBigDecimal(int columnIndex, BigDecimal x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateBigDecimal(String columnName, BigDecimal x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateBinaryStream(int columnIndex, InputStream x,
				int length) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateBinaryStream(String columnName, InputStream x,
				int length) throws SQLException {
			throw new UnsupportedOperationException();
		}
		
		public void updateBlob(int columnIndex, Blob x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateBlob(String columnName, Blob x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateBoolean(int columnIndex, boolean x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateBoolean(String columnName, boolean x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateByte(int columnIndex, byte x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateByte(String columnName, byte x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateBytes(int columnIndex, byte[] x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateBytes(String columnName, byte[] x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateCharacterStream(int columnIndex, Reader x, int length)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateCharacterStream(String columnName, Reader reader,
				int length) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateClob(int columnIndex, Clob x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateClob(String columnName, Clob x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateDate(int columnIndex, Date x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateDate(String columnName, Date x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateDouble(int columnIndex, double x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateDouble(String columnName, double x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateFloat(int columnIndex, float x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateFloat(String columnName, float x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateInt(int columnIndex, int x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateInt(String columnName, int x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateLong(int columnIndex, long x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateLong(String columnName, long x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateNull(int columnIndex) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateNull(String columnName) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateObject(int columnIndex, Object x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateObject(String columnName, Object x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateObject(int columnIndex, Object x, int scale)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateObject(String columnName, Object x, int scale)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateRef(int columnIndex, Ref x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateRef(String columnName, Ref x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateRow() throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateShort(int columnIndex, short x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateShort(String columnName, short x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateString(int columnIndex, String x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateString(String columnName, String x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateTime(int columnIndex, Time x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateTime(String columnName, Time x) throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateTimestamp(int columnIndex, Timestamp x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public void updateTimestamp(String columnName, Timestamp x)
				throws SQLException {
			throw new UnsupportedOperationException();
		}

		public boolean wasNull() throws SQLException {
			return false;
		}

	}

	public class TestInserter implements Inserter {
		protected Map<String, Object> row = new HashMap<String, Object>();

		public void close() {
			//noop
		}

		public void flush() throws SQLException {
			//noop
		}

		public int getLastId() {
			return 0;
		}

		public void insert(Map<String, Object> data) throws SQLException {
			row.putAll(data);
		}

		public void open(Connection conn) throws SQLException {
			//noop
		}

		public void updateRow() throws SQLException {
			Object[] r = new Object[columns.length];
			
			int i = 0;
			for (String c: columns) {
				r[i++] = row.get(c);
			}
			
			addRow(r);
			row.clear();
		}

		public void updateBigDecimal(String columnName, BigDecimal x)
				throws SQLException {
			updateObject(columnName, x);
		}

		public void updateBlob(String columnName, Blob x) throws SQLException {
			updateObject(columnName, x);
		}

		public void updateBoolean(String columnName, boolean x)
				throws SQLException {
			updateObject(columnName, x);
		}

		public void updateByte(String columnName, byte x) throws SQLException {
			updateObject(columnName, x);
		}

		public void updateBytes(String columnName, byte[] x)
				throws SQLException {
			updateObject(columnName, x);
		}

		public void updateClob(String columnName, Clob x) throws SQLException {
			updateObject(columnName, x);
		}

		public void updateDate(String columnName, Date x) throws SQLException {
			updateObject(columnName, x);
		}

		public void updateDouble(String columnName, double x)
				throws SQLException {
			updateObject(columnName, x);
		}

		public void updateFloat(String columnName, float x) throws SQLException {
			updateObject(columnName, x);
		}

		public void updateInt(String columnName, int x) throws SQLException {
			updateObject(columnName, x);
		}

		public void updateLong(String columnName, long x) throws SQLException {
			updateObject(columnName, x);
		}

		public void updateNull(String columnName) throws SQLException {
			updateObject(columnName, null);
		}

		public void updateObject(String columnName, Object x)
				throws SQLException {
			row.put(columnName, x);
		}

		public void updateShort(String columnName, short x) throws SQLException {
			updateObject(columnName, x);
		}

		public void updateString(String columnName, String x)
				throws SQLException {
			updateObject(columnName, x);
		}

		public void updateTime(String columnName, Time x) throws SQLException {
			updateObject(columnName, x);
		}

		public void updateTimestamp(String columnName, Timestamp x)
				throws SQLException {
			updateObject(columnName, x);
		}

		public DatabaseTable getTable() {
			return null;
		}

		public boolean isLenient() {
			return false;
		}

		public void setLenient(boolean lenient) {
			//noop
		}

		public void disableAutomaticField() {
			// TODO Auto-generated method stub
			
		}

	}

	protected List<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
	protected String[] columns;
	
	public TestData(String[] columns) {
		this.columns = columns;
	}

	public void addRow(Object[] row) {
		Map<String, Object> m = new HashMap<String, Object>();
		for (int i = 0; i<row.length; i++) {
			m.put(columns[i], row[i]);
		}
		data.add(m);
	}
	
	@Override
	public String toString() {
		return data.toString();
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + Arrays.hashCode(columns);
		result = PRIME * result + ((data == null) ? 0 : data.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final TestData other = (TestData) obj;
		if (!Arrays.equals(columns, other.columns))
			return false;
		if (data == null) {
			if (other.data != null)
				return false;
		} else if (!data.equals(other.data))
			return false;
		return true;
	}

	public ResultSet resultSet() {
		return new TestResultSet();
	}

	public Inserter inserter() {
		return new TestInserter();
	}
	
	
}
