package de.brightbyte.db.file;

import java.io.File;
import java.io.IOException;

import de.brightbyte.util.PersistenceException;

import junit.framework.TestCase;

public class BinaryDumpTest extends TestCase {
	
	public void testRoundTrip() throws IOException, PersistenceException {
		BinaryDump.Codec[]  codecs = new BinaryDump.Codec[] {
				new BinaryDump.IntegerCodec("id"), 
				new BinaryDump.StringCodec("name", null), 
				new BinaryDump.DoubleCodec("value") 
		};
		
		String[] columns = new String[] { "id", "name", "value" } ;
		
		TestData data = new TestData( columns );
		data.addRow( new Object[] { 1, "foo", 0.21 } );
		data.addRow( new Object[] { 2, "bar", 2345.6789 } );
		data.addRow( new Object[] { 3, "raz", -77.2239548 } );
		data.addRow( new Object[] { 4, "äöü", 88844.4221 } );
		data.addRow( new Object[] { 5, "", 88844422.1 } );
		
		File f = File.createTempFile("BinaryDumpTest-", ".dat");
		f.deleteOnExit();
		
		BinaryDump dump = new BinaryDump("test", codecs );
		dump.write(data.resultSet(), f);
		
		TestData data2 = new TestData( columns );
		dump.read(f, data2.inserter());
		
		f.delete();
		
		assertEquals(data, data2);
	}
}
