package de.brightbyte.db;

import java.sql.SQLException;

public class UncheckedSQLException extends RuntimeException {

	protected SQLException sqlex;
	
	public UncheckedSQLException(String message, SQLException cause) {
		super(message, cause);
		sqlex = cause;
	}

	public UncheckedSQLException(SQLException cause) {
		super(cause); 
		sqlex = cause;
	}

	public int getErrorCode() {
		return sqlex.getErrorCode();
	}

	public String getSQLState() {
		return sqlex.getSQLState();
	}

}
