package de.brightbyte.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StatementBasedInserter extends BufferedInserterBase {
	
	public static final InserterFactory factory = new InserterFactory() {
		public Inserter newInserter(DatabaseTable table, String automaticField, int bufferLength, int bufferWidth) throws SQLException {
			return new StatementBasedInserter(table, automaticField);
		}
	};
	
	protected PreparedStatement statement;
	protected String[] params;
	
	public StatementBasedInserter(DatabaseTable table, String automaticField) {
		super(table, automaticField);
	}

	@Override
	protected void pushRow() throws SQLException {
		if (statement==null) connect();		
		
		for (int i = 0; i < params.length; i++) {
			Object v = insertRow.get(params[i]);
			statement.setObject(i+1, v);
		}
		
		try {
			statement.executeUpdate();
			//flush();
		}
		catch (SQLException ex) {
			String msg = "Error while executing prepared statement "+statement.toString()+" on table "+table;
			throw (SQLException)new SQLException( msg ).initCause(ex);
		}
	}

	protected void connect() throws SQLException {
		if (statement!=null) return;		
		Connection conn = table.getAccess().getConnection();
		
		params = new String[fields.size()];
		int i = 0;
		for (DatabaseField field : fields.values()) {
			params[i++] = field.getName();
		}
		
		StringBuilder sql = new StringBuilder();
		sql.append("INSERT ");
		if (lenient) sql.append("IGNORE "); 
		sql.append("INTO ");
		sql.append(access.quoteName(table.getSQLName()));
		sql.append(" ( ");
		for (int j = 0; j < params.length; j++) {
			if (j>0) sql.append(", ");
			sql.append(access.quoteName(params[j]));
		}
		sql.append(" ) ");
		sql.append(" VALUES ");
		sql.append(" ( ");
		for (int j = 0; j < params.length; j++) {
			if (j>0) sql.append(", ");
			sql.append("? ");
		}
		sql.append(" ) ");
		
		statement = conn.prepareStatement(sql.toString(), ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
	}

	@Override
	public void close() {
		try {
			if (statement!=null) statement.close();
			statement = null;
		} catch (SQLException e) { /* ignore */ }
	}

	@Override
	public void flush() throws SQLException {
		//noop
	}

}
