package de.brightbyte.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

public class SingletonDataSource implements DataSource {

	private Connection connection;
	private PrintWriter log = null;

	public SingletonDataSource(Connection connection) {
		super();
		this.connection = connection;
	}

	public Connection getConnection() throws SQLException {
		return connection;
	}

	public Connection getConnection(String username, String password)
			throws SQLException {
		return connection;
	}

	public PrintWriter getLogWriter() throws SQLException {
		return log;
	}

	public int getLoginTimeout() throws SQLException {
		return 0;
	}

	public void setLogWriter(PrintWriter out) throws SQLException {
		log = out;
	}

	public void setLoginTimeout(int seconds) throws SQLException {
		//ignore
	}

}
