package de.brightbyte.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class ResultSetIterator implements Iterator<ResultSet> {
	protected ResultSet cursor;
	protected boolean pending = true;
	protected boolean has = true;

	public ResultSetIterator(ResultSet cursor) {
		super();
		this.cursor = cursor;
	}

	public boolean hasNext() {
		try {
			if (pending) {
				has = cursor.next();
				pending = false;
			}
			
			return has;
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	public ResultSet next() {
		try {
			if (pending) {
				has = cursor.next();
				pending = false;
			}

			if (!has) return null;
			
			pending = true;
			return cursor;
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	public void remove() {
		throw new UnsupportedOperationException();
	}

}
