package de.brightbyte.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import de.brightbyte.abstraction.Abstractor;

public class ResultSetAbstractor implements Abstractor<ResultSet> {

	public static final ResultSetAbstractor instance = new ResultSetAbstractor();

	public Object getProperty(ResultSet obj, String name) throws IllegalArgumentException {
		try {
			return obj.getObject(name);
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	public Class getPropertyType(String property) {
		return Object.class; //XXX: if we had a concrete result set, we could determin the type
	}

	public Class<ResultSet> getTargetType() {
		return ResultSet.class;
	}

	public boolean isPropertyMutable(String name) {
		return false;
	}

	public void setProperty(ResultSet obj, String name, Object v) throws IllegalArgumentException {
		throw new UnsupportedOperationException();
	}

	public boolean hasProperty(ResultSet obj, String name) {
		try {
			ResultSetMetaData meta = obj.getMetaData();
			int c = meta.getColumnCount();
			for (int i=1; i<=c; i++) {
				String n = meta.getColumnLabel(i);
				if (n.equals(name)) return true;
			}
			return false;
		} catch (SQLException e) {
			throw new UncheckedSQLException(e);
		}
	}

}
