package de.brightbyte.db;

public class ReferenceField extends DatabaseField {
	
	protected String targetTable;
	protected String targetField;
	protected String referenceAction;
	
	protected String contraintSQL;

	public ReferenceField(DatabaseAccess access, String name, String type, String attributes, boolean required, KeyType keyType, String refTable, String refField, String refAction) {
		super(access, name, type, attributes, required, keyType);
		
		this.targetField = refField;
		this.targetTable = refTable;
		this.referenceAction = refAction;
		
		StringBuilder s = new StringBuilder();
		s.append("FOREIGHN KEY ");
		s.append(" ( ");
		s.append(name);
		s.append(" ) ");
		s.append("REFERENCES ");
		s.append(refTable);
		s.append(" ( ");
		s.append(targetField);
		s.append(" ) ");
		
		if (refAction!=null) {
			s.append(refAction);
		}
		
		contraintSQL = s.toString();
	}
	
	public String getContraintSQL() {
		return contraintSQL;
	}
	
	@Override
	public String toString() {
		return getSQL() + "; " + getContraintSQL();
	}

	public String getReferenceAction() {
		return referenceAction;
	}

	public String getTargetField() {
		return targetField;
	}

	public String getTargetTable() {
		return targetTable;
	}

	
}
