package de.brightbyte.db;

import java.sql.ResultSet;
import java.sql.SQLException;

public class QueryDataSet<T> extends DatabaseDataSet<T> {
	protected String name;
	protected String sql;
	protected boolean big;
	
	/*public DatabaseDataSet(DatabaseAccess access, String name, String sql) {
		this(access, name, sql, false);
	}*/
	
	public QueryDataSet(DatabaseAccess access, Factory<T> factory, String name, String sql, boolean big) {
		super(access, factory);
		this.name = name;
		this.sql = sql;
		this.big = big;
	}
	
	protected String getSQL() {
		if (sql==null) throw new IllegalStateException("No SQL query known. either provide an sql query to the constructor, or override getSQL()!");
		return sql;
	}

	@Override
	protected ResultSet execute() throws SQLException {
		String sql = getSQL();
		ResultSet rs = big ? access.executeBigQuery(name, sql) : access.executeQuery(name, sql);
		return rs;
	}
	
}
