package de.brightbyte.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;


public abstract class PreparedStatementDataSet<T> extends DatabaseDataSet<T> {
	
	protected PreparedStatement statement;
	protected ResultSet result;
	
	public PreparedStatementDataSet(DatabaseAccess access, Factory<T> factory, String name, String sql, boolean big) throws SQLException {
		this(access, factory, access.prepareStatement(sql));
		
		if (big) statement.setFetchSize(Integer.MIN_VALUE);
	}

	public PreparedStatementDataSet(DatabaseAccess access, Factory<T> factory, PreparedStatement st) throws SQLException {
		super(access, factory);
		this.statement = st;
	}
	
	public void reset(Object... params) throws SQLException {
		if (result != null) result.close();
		
		for(int i=0; i<params.length; i++) {
			statement.setObject(i+1, params[i]);
		}
	}

	@Override
	protected ResultSet execute() throws SQLException {
		result = statement.executeQuery();
		return result;
	}

	@Override
	public List<T> load() {
		return super.load();
	}
	
	
}
