package de.brightbyte.db;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public interface Inserter {

	/**
	 * set if duplicates should be ignored 
	 */
	public abstract void setLenient(boolean lenient);
	
	/**
	 * set if duplicates should be ignored 
	 */
	public abstract void disableAutomaticField();
	
	/**
	 * returns true iff duplicates will be ignored 
	 */
	public abstract boolean isLenient();
	
	public abstract DatabaseTable getTable();

	public abstract int getLastId() throws SQLException;

	public abstract void flush() throws SQLException;

	public abstract void close();

	public abstract void insert(Map<String, Object> data) throws SQLException;

	public abstract void updateRow() throws SQLException;

	public abstract void updateBigDecimal(String columnName, BigDecimal x)
			throws SQLException;

	public abstract void updateBlob(String columnName, Blob x)
			throws SQLException;

	public abstract void updateBoolean(String columnName, boolean x)
			throws SQLException;

	public abstract void updateByte(String columnName, byte x)
			throws SQLException;

	public abstract void updateBytes(String columnName, byte[] x)
			throws SQLException;

	public abstract void updateClob(String columnName, Clob x)
			throws SQLException;

	public abstract void updateDate(String columnName, Date x)
			throws SQLException;

	public abstract void updateDouble(String columnName, double x)
			throws SQLException;

	public abstract void updateFloat(String columnName, float x)
			throws SQLException;

	public abstract void updateInt(String columnName, int x)
			throws SQLException;

	public abstract void updateLong(String columnName, long x)
			throws SQLException;

	public abstract void updateNull(String columnName) throws SQLException;

	public abstract void updateObject(String columnName, Object x)
			throws SQLException;

	public abstract void updateShort(String columnName, short x)
			throws SQLException;

	public abstract void updateString(String columnName, String x)
			throws SQLException;

	public abstract void updateTime(String columnName, Time x)
			throws SQLException;

	public abstract void updateTimestamp(String columnName, Timestamp x)
			throws SQLException;

}