package de.brightbyte.db;

import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import static java.sql.Types.*;

public class DatabaseUtil {

	public static String getColumnFormat(ResultSetMetaData meta, int col) throws SQLException {
		//TODO: support padding
		
		if (isNumeric(meta, col)) {
			int scale = meta.getScale(col);
			if (scale == 0) return "%d";
			else return "%."+scale+"f";
		}
		
		return null;
	}

	public static boolean isNumeric(ResultSetMetaData meta, int col) throws SQLException {
		int type = meta.getColumnType(col);
		return isNumeric(type);
	}
	
	public static boolean isNumeric(int type) throws SQLException {
		if ( type == BIT || type == TINYINT || type == SMALLINT || type == INTEGER || type == BIGINT
				|| type == FLOAT || type == REAL || type == DOUBLE || type == NUMERIC || type == DECIMAL ) {
			return true;
		}
		
		return false;
	}

	public static boolean isInteger(ResultSetMetaData meta, int col) throws SQLException {
		int type = meta.getColumnType(col);
		return isInteger(type);
	}
	
	public static boolean isInteger(int type) throws SQLException {
		if ( type == BIT || type == TINYINT || type == SMALLINT || type == INTEGER || type == BIGINT ) {
			return true;
		}
		
		return false;
	}

	
	public static int asInt(Object o) {
		if (o instanceof Boolean) return 1;
		return ((Number)o).intValue();
	}
	
	public static double asDouble(Object o) {
		if (o instanceof Boolean) return 1.0;
		return ((Number)o).doubleValue();
	}
	
	public static int asInt(Object o, int def) {
		if (o==null) return def;
		return asInt(o);
	}
	
	public static double asDouble(Object o, double def) {
		if (o==null) return def;
		return asDouble(o);
	}
	
	public static String asString(Object o) {
		return asString(o, "UTF-8");
	}
	
	public static String asString(Object o, String enc) {
		if (o==null) return null;
		
		if (o instanceof String) {
			return (String)o;
		}
		
		if (o instanceof Clob) {
			try {
				return ((Clob)o).getSubString(0, (int)((Clob)o).length());
			} catch (SQLException e) {
				throw new UncheckedSQLException(e);
			}
		}
		
		if (o instanceof Blob) {
			try {
				o = ((Blob)o).getBytes(0, (int)((Blob)o).length());
				//NOTE: fall through to byte[] case!
			} catch (SQLException e) {
				throw new UncheckedSQLException(e);
			}
		}

		if (o instanceof byte[]) {
			try {
				return new String((byte[])o, enc);
			} catch (UnsupportedEncodingException e) {
				throw new Error("UTF-8 not supported!", e);
			}
		}
		
		if (o instanceof char[]) {
			return new String((char[])o);
		}
		
		return o.toString();
	}
	
}
