package de.brightbyte.db;

public class DatabaseKey {
	protected DatabaseAccess access;
	protected KeyType type;
	protected String name;
	protected String[] fields;
	protected String sql;
	
	public DatabaseKey(DatabaseAccess access, KeyType type, String name, String[] fields) {
		super();
		
		this.access  = access;
		this.type = type;
		this.name = name;
		this.fields = fields;

		StringBuilder s = new StringBuilder();
		s.append(type.getName());
		s.append(" ");
		if (type!=KeyType.PRIMARY) s.append(access.quoteName(name));
		s.append(" ( ");
		for (int i = 0; i < fields.length; i++) {
			if (i>0) s.append(", ");
			s.append(access.quoteName(fields[i]));
		}
		s.append(" )");
		sql = s.toString();
	}
	
	public String[] getFields() {
		return fields;
	}
	
	public String getName() {
		return name;
	}
	
	public KeyType getType() {
		return type;
	}
	
	public boolean isUnique() {
		return type.isUnique(); 
	}
	
	public String getSQL() {
		return sql;
	}
	
	@Override
	public String toString() {
		return getSQL();
	}
}
