package de.brightbyte.db;

import java.sql.ResultSet;
import java.sql.SQLException;

import de.brightbyte.data.cursor.DataCursor;
import de.brightbyte.util.PersistenceException;

public class ChunkedQueryDataSet<T> extends DatabaseDataSet<T> {
	protected class ChunkedQuerySetCursor extends DatabaseDataSet.Cursor<T>{
		private int first;
		private int maxId;
		private int chunkStep;
		private int index;
		private long end;
		
		public ChunkedQuerySetCursor(DatabaseAccess.ChunkingInfo info) {
			super(ChunkedQueryDataSet.this.factory);
			this.maxId = info == null ? Integer.MAX_VALUE : info.maxId;
			this.chunkStep = info == null ? Integer.MAX_VALUE : info.chunkStep;
			this.first = info == null ? 0 : info.minId;
			this.end = first + chunkStep;
			this.index = 0;
		}

		@Override
		protected boolean fetchNext() throws Exception {
			if (!more) return false;
			
			while (first <= maxId) {
				if (resultSet!=null && resultSet.next()) return true;
				else resultSet = null;
				
				index++;
				
				resultSet = query.executeQuery(index, first, end);
				if (resultSet==null) return false;
				
				first += chunkStep;
				end += chunkStep;
			}
			
			return false;
		}
	}
	
	protected DatabaseAccess.ChunkedQuery query;
	protected DatabaseAccess.ChunkingInfo chunkingInfo;

	public ChunkedQueryDataSet(DatabaseAccess access, Factory<T> factory, String context, String name, String sql, String where, String rest, DatabaseTable chunkTable, String chunkField, int chunkSize) throws SQLException {
		this(access, factory, new DatabaseAccess.SimpleChunkedQuery(access, context, name, sql, where, rest, chunkTable, chunkField), chunkSize);
	}
	
	public ChunkedQueryDataSet(DatabaseAccess access, Factory<T> factory, DatabaseAccess.ChunkedQuery query, int chunkSize) throws SQLException {
		super(access, factory);
		this.chunkingInfo = access.getChunkingInfo(query, chunkSize);
		this.query = query;
	}

	@Override
	public DataCursor<T> cursor() throws PersistenceException {
		return new ChunkedQuerySetCursor(chunkingInfo);
	}

	@Override
	protected ResultSet execute() throws SQLException {
		throw new UnsupportedOperationException();
	}

}