package de.brightbyte.db;

import java.sql.ResultSet;
import java.util.Map;

public abstract class AbstractResultSetProcessor implements ResultSetProcessor {

	public void process(ResultSet rs) throws Exception {
		while (rs.next()) {
			processRow(rs);
		}
	}

	protected void processRow(ResultSet rs) throws Exception {
		Map<String, Object> data = DatabaseSchema.rowMap(rs);
		processRow(data);
	}

	protected void processRow(Map<String, Object> data) throws Exception {
		throw new UnsupportedOperationException("please override either processRow(ResultSet) or processRow(Map)");
	}
}
